/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli.svn;

public class SVNConflictAcceptPolicy {
    public static final SVNConflictAcceptPolicy INVALID = new SVNConflictAcceptPolicy("invalid");
    public static final SVNConflictAcceptPolicy UNSPECIFIED = new SVNConflictAcceptPolicy("unspecified");
    public static final SVNConflictAcceptPolicy BASE = new SVNConflictAcceptPolicy("base");
    public static final SVNConflictAcceptPolicy MINE_CONFLICT = new SVNConflictAcceptPolicy("mine-conflict");
    public static final SVNConflictAcceptPolicy MINE_FULL = new SVNConflictAcceptPolicy("mine-full");
    public static final SVNConflictAcceptPolicy WORKING = new SVNConflictAcceptPolicy("working");
    public static final SVNConflictAcceptPolicy THEIRS_CONFLICT = new SVNConflictAcceptPolicy("theirs-conflict");
    public static final SVNConflictAcceptPolicy THEIRS_FULL = new SVNConflictAcceptPolicy("theirs-full");
    public static final SVNConflictAcceptPolicy POSTPONE = new SVNConflictAcceptPolicy("postpone");
    public static final SVNConflictAcceptPolicy EDIT = new SVNConflictAcceptPolicy("edit");
    public static final SVNConflictAcceptPolicy LAUNCH = new SVNConflictAcceptPolicy("launch");
    private String myName;

    private SVNConflictAcceptPolicy(String name) {
        this.myName = name;
    }

    public String toString() {
        return this.myName;
    }

    public static SVNConflictAcceptPolicy fromString(String accept) {
        if (SVNConflictAcceptPolicy.POSTPONE.myName.equals(accept) || "p".equals(accept) || ":-P".equals(accept)) {
            return POSTPONE;
        }
        if (SVNConflictAcceptPolicy.BASE.myName.equals(accept)) {
            return BASE;
        }
        if (SVNConflictAcceptPolicy.MINE_CONFLICT.myName.equals(accept) || "mc".equals(accept) || "X-)".equals(accept)) {
            return MINE_CONFLICT;
        }
        if (SVNConflictAcceptPolicy.THEIRS_CONFLICT.myName.equals(accept) || "tc".equals(accept) || "X-(".equals(accept)) {
            return THEIRS_CONFLICT;
        }
        if (SVNConflictAcceptPolicy.EDIT.myName.equals(accept) || "e".equals(accept) || ":-E".equals(accept)) {
            return EDIT;
        }
        if (SVNConflictAcceptPolicy.LAUNCH.myName.equals(accept) || "l".equals(accept) || ":-l".equals(accept)) {
            return LAUNCH;
        }
        if (SVNConflictAcceptPolicy.MINE_FULL.myName.equals(accept) || "mf".equals(accept) || ":-)".equals(accept)) {
            return MINE_FULL;
        }
        if (SVNConflictAcceptPolicy.THEIRS_FULL.myName.equals(accept) || "tf".equals(accept) || ":-(".equals(accept)) {
            return THEIRS_FULL;
        }
        if (SVNConflictAcceptPolicy.WORKING.myName.equals(accept)) {
            return WORKING;
        }
        return INVALID;
    }
}

