/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli.svn;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.tmatesoft.svn.cli.SVNCommandUtil;
import org.tmatesoft.svn.cli.svn.SVNNotifyPrinter;
import org.tmatesoft.svn.cli.svn.SVNOption;
import org.tmatesoft.svn.cli.svn.SVNPropertiesCommand;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNPath;
import org.tmatesoft.svn.core.internal.wc.SVNPropertiesManager;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.ISVNPropertyHandler;
import org.tmatesoft.svn.core.wc.SVNPropertyData;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNWCClient;
import org.tmatesoft.svn.core.wc2.ISvnObjectReceiver;
import org.tmatesoft.svn.core.wc2.SvnGetProperties;
import org.tmatesoft.svn.core.wc2.SvnInheritedProperties;
import org.tmatesoft.svn.core.wc2.SvnOperationFactory;
import org.tmatesoft.svn.core.wc2.SvnTarget;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNPropGetCommand
extends SVNPropertiesCommand {
    public SVNPropGetCommand() {
        super("propget", new String[]{"pget", "pg"});
    }

    @Override
    protected Collection<SVNOption> createSupportedOptions() {
        LinkedList<SVNOption> options = new LinkedList<SVNOption>();
        options.add(SVNOption.VERBOSE);
        options.add(SVNOption.RECURSIVE);
        options.add(SVNOption.DEPTH);
        options.add(SVNOption.REVISION);
        options.add(SVNOption.REVPROP);
        options.add(SVNOption.STRICT);
        options.add(SVNOption.XML);
        options.add(SVNOption.CHANGELIST);
        options.add(SVNOption.SHOW_INHERITED_PROPS);
        options.add(SVNOption.NO_NEWLINE);
        return options;
    }

    @Override
    public void run() throws SVNException {
        SVNErrorMessage err;
        String propertyName;
        if (this.getSVNEnvironment().isVerbose() && (this.getSVNEnvironment().isRevprop() || this.getSVNEnvironment().isNoNewLine() || this.getSVNEnvironment().isXML())) {
            SVNErrorMessage errorMessage = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_MUTUALLY_EXCLUSIVE_ARGS, (String)"--verbose cannot be used with --revprop or --no-newline or --xml");
            SVNErrorManager.error((SVNErrorMessage)errorMessage, (SVNLogType)SVNLogType.CLIENT);
        }
        if ((propertyName = this.getSVNEnvironment().popArgument()) == null) {
            err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_INSUFFICIENT_ARGS);
            SVNErrorManager.error((SVNErrorMessage)err, (SVNLogType)SVNLogType.CLIENT);
        }
        if (!SVNPropertiesManager.isValidPropertyName((String)propertyName)) {
            err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CLIENT_PROPERTY_NAME, (String)"''{0}'' is not a valid Subversion property name", (Object)propertyName);
            SVNErrorManager.error((SVNErrorMessage)err, (SVNLogType)SVNLogType.CLIENT);
        }
        List<Object> targets = new LinkedList();
        targets = this.getSVNEnvironment().combineTargets(targets, true);
        if (targets.isEmpty()) {
            targets.add("");
        }
        if (this.getSVNEnvironment().isRevprop()) {
            long rev;
            SVNWCClient wcClient = this.getSVNEnvironment().getClientManager().getWCClient();
            String target = this.checkRevPropTarget(this.getSVNEnvironment().getStartRevision(), targets);
            if (SVNCommandUtil.isURL(target)) {
                rev = wcClient.doGetRevisionProperty(SVNURL.parseURIEncoded((String)target), propertyName, this.getSVNEnvironment().getStartRevision(), (ISVNPropertyHandler)this);
            } else {
                File targetPath = new SVNPath(target).getFile();
                rev = wcClient.doGetRevisionProperty(targetPath, propertyName, this.getSVNEnvironment().getStartRevision(), (ISVNPropertyHandler)this);
            }
            SVNPropertyData propertyValue = this.getRevisionProperty(rev);
            if (propertyValue != null) {
                if (this.getSVNEnvironment().isXML()) {
                    this.printXMLHeader("properties");
                    StringBuffer buffer = this.openXMLTag("revprops", 1, "rev", Long.toString(rev), null);
                    buffer = this.addXMLProp(propertyValue, false, buffer);
                    buffer = this.closeXMLTag("revprops", buffer);
                    this.getSVNEnvironment().getOut().print(buffer);
                    this.printXMLFooter("properties");
                } else {
                    if (propertyValue.getValue().isString()) {
                        this.getSVNEnvironment().getOut().print(propertyValue.getValue());
                    } else {
                        try {
                            this.getSVNEnvironment().getOut().write(propertyValue.getValue().getBytes());
                        }
                        catch (IOException buffer) {
                            // empty catch block
                        }
                    }
                    if (!this.getSVNEnvironment().isStrict() && !this.getSVNEnvironment().isNoNewLine()) {
                        this.getSVNEnvironment().getOut().println();
                    }
                }
            }
            this.clearCollectedProperties();
        } else {
            SVNDepth depth;
            if (this.getSVNEnvironment().isXML()) {
                this.printXMLHeader("properties");
            }
            if ((depth = this.getSVNEnvironment().getDepth()) == SVNDepth.UNKNOWN) {
                depth = SVNDepth.EMPTY;
            }
            if (this.getSVNEnvironment().isNoNewLine() && (targets.size() > 1 || depth != SVNDepth.EMPTY || this.getSVNEnvironment().isShowInheritedProps())) {
                SVNErrorMessage errorMessage = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_ARG_PARSING_ERROR, (String)"--no-newline is only available for single-target, non-recursive propget operations");
                SVNErrorManager.error((SVNErrorMessage)errorMessage, (SVNLogType)SVNLogType.CLIENT);
            }
            boolean likeProplist = this.getSVNEnvironment().isVerbose() && !this.getSVNEnvironment().isStrict() && !this.getSVNEnvironment().isNoNewLine();
            Collection changeLists = this.getSVNEnvironment().getChangelistsCollection();
            SVNWCClient client = this.getSVNEnvironment().getClientManager().getWCClient();
            SVNNotifyPrinter printer = new SVNNotifyPrinter(this.getSVNEnvironment());
            client.setEventHandler((ISVNEventHandler)printer);
            for (String string : targets) {
                SVNPath target = new SVNPath(string, true);
                SVNRevision pegRevision = target.getPegRevision();
                boolean printFileNames = false;
                SvnOperationFactory of = client.getOperationsFactory();
                SvnGetProperties pl = of.createGetProperties();
                if (target.isURL()) {
                    pl.setSingleTarget(SvnTarget.fromURL((SVNURL)target.getURL(), (SVNRevision)pegRevision));
                } else {
                    pl.setSingleTarget(SvnTarget.fromFile((File)target.getFile(), (SVNRevision)pegRevision));
                }
                pl.setDepth(depth);
                pl.setRevision(this.getSVNEnvironment().getStartRevision());
                pl.setApplicalbeChangelists(changeLists);
                pl.setReceiver((ISvnObjectReceiver)new ISvnObjectReceiver<SVNProperties>(){

                    public void receive(SvnTarget target, SVNProperties props) throws SVNException {
                        if (!props.containsName(propertyName)) {
                            return;
                        }
                        SVNPropertyData propertyData = new SVNPropertyData(propertyName, props.getSVNPropertyValue(propertyName), (ISVNOptions)SVNPropGetCommand.this.getSVNEnvironment().getOptions());
                        if (target.isURL()) {
                            SVNPropGetCommand.this.handleProperty(target.getURL(), propertyData);
                        } else {
                            SVNPropGetCommand.this.handleProperty(target.getFile(), propertyData);
                        }
                    }
                });
                if (this.getSVNEnvironment().isShowInheritedProps()) {
                    pl.setTargetInheritedPropertiesReceiver((ISvnObjectReceiver)new ISvnObjectReceiver<List<SvnInheritedProperties>>(){

                        public void receive(SvnTarget target, List<SvnInheritedProperties> propsList) throws SVNException {
                            if (SVNPropGetCommand.this.getSVNEnvironment().isXML()) {
                                SVNPropGetCommand.this.printInhertiedPropertiesXML(target, propertyName, propsList);
                            }
                        }
                    });
                }
                printFileNames = target.isURL() ? !this.getSVNEnvironment().isStrict() && !this.getSVNEnvironment().isNoNewLine() && (this.getSVNEnvironment().isVerbose() || depth.compareTo((Object)SVNDepth.EMPTY) > 0 || targets.size() > 1 || this.getURLProperties().size() > 1) : !this.getSVNEnvironment().isStrict() && !this.getSVNEnvironment().isNoNewLine() && (this.getSVNEnvironment().isVerbose() || depth.compareTo((Object)SVNDepth.EMPTY) > 0 || targets.size() > 1 || this.getPathProperties().size() > 1);
                boolean omitNewLine = this.getSVNEnvironment().isNoNewLine();
                pl.run();
                if (!this.getSVNEnvironment().isXML()) {
                    this.printCollectedProperties(printFileNames, target.isURL(), likeProplist, omitNewLine);
                } else {
                    this.printCollectedPropertiesXML(target.isURL());
                }
                this.clearCollectedProperties();
            }
            if (this.getSVNEnvironment().isXML()) {
                this.printXMLFooter("properties");
            }
        }
    }

    protected void printCollectedProperties(boolean printFileName, boolean isURL, boolean likePropList, boolean omitNewLine) {
        Map map = isURL ? this.getURLProperties() : this.getPathProperties();
        for (Object key : map.keySet()) {
            List props = (List)map.get(key);
            if (printFileName) {
                if (isURL) {
                    if (likePropList) {
                        this.getSVNEnvironment().getOut().println("Properties on '" + key + "':");
                    } else {
                        this.getSVNEnvironment().getOut().print(key);
                        this.getSVNEnvironment().getOut().print(" - ");
                    }
                } else {
                    String path = SVNCommandUtil.getLocalPath(this.getSVNEnvironment().getRelativePath((File)key));
                    if (likePropList) {
                        this.getSVNEnvironment().getOut().println("Properties on '" + path + "':");
                    } else {
                        this.getSVNEnvironment().getOut().print(path);
                        this.getSVNEnvironment().getOut().print(" - ");
                    }
                }
            }
            if (likePropList) {
                this.printProplist(props, omitNewLine);
                continue;
            }
            SVNPropertyData property = (SVNPropertyData)props.get(0);
            this.printProperty(property.getValue(), likePropList, omitNewLine);
            if (this.getSVNEnvironment().isStrict() || this.getSVNEnvironment().isNoNewLine()) continue;
            this.getSVNEnvironment().getOut().println();
        }
    }

    private void printInhertiedPropertiesXML(SvnTarget target, String propertyName, List<SvnInheritedProperties> propsList) {
        for (SvnInheritedProperties props : propsList) {
            SVNPropertyValue pv = props.getProperties().getSVNPropertyValue(propertyName);
            if (pv == null) continue;
            SVNPropertyData pd = new SVNPropertyData(propertyName, pv, (ISVNOptions)this.getSVNEnvironment().getOptions());
            String name = props.getTarget().isURL() ? props.getTarget().getPathOrUrlString() : SVNFileUtil.getFilePath((File)props.getTarget().getFile());
            StringBuffer buffer = this.openXMLTag("target", 1, "path", name, null);
            buffer = this.addXMLProp(pd, true, buffer);
            buffer = this.closeXMLTag("target", buffer);
            this.getSVNEnvironment().getOut().print(buffer);
        }
    }

    protected void printCollectedPropertiesXML(boolean isURL) {
        Map map = isURL ? this.getURLProperties() : this.getPathProperties();
        for (Object key : map.keySet()) {
            List props = (List)map.get(key);
            String target = key.toString();
            if (!isURL) {
                target = SVNCommandUtil.getLocalPath(this.getSVNEnvironment().getRelativePath((File)key));
            }
            SVNPropertyData property = (SVNPropertyData)props.get(0);
            StringBuffer buffer = this.openXMLTag("target", 1, "path", target, null);
            buffer = this.addXMLProp(property, false, buffer);
            buffer = this.closeXMLTag("target", buffer);
            this.getSVNEnvironment().getOut().print(buffer);
        }
    }
}

