/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.tmatesoft.svn.cli.AbstractSVNOption;
import org.tmatesoft.svn.cli.SVNOptionValue;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNCommandLine {
    private static final Map ourOptions = new SVNHashMap();
    private String myCommand;
    private Collection myArguments = new LinkedList();
    private Collection myOptions = new LinkedList();
    private boolean myNeedsCommand;
    private int myArgumentIndex;
    private int myArgumentPosition;
    private String[] myInputArguments;

    public static void registerOption(AbstractSVNOption option) {
        if (option.getName() != null) {
            ourOptions.put("--" + option.getName(), option);
        }
        if (option.getAlias() != null) {
            ourOptions.put("-" + option.getAlias(), option);
        }
        if (option.getLongAlias() != null) {
            ourOptions.put("--" + option.getLongAlias(), option);
        }
    }

    public SVNCommandLine() {
        this(true);
    }

    public SVNCommandLine(boolean needsCommand) {
        this.myNeedsCommand = needsCommand;
    }

    public void init(String[] args) throws SVNException {
        SVNOptionValue value;
        this.myInputArguments = args;
        this.myArgumentPosition = 0;
        this.myArgumentIndex = 0;
        this.myArguments = new LinkedList();
        this.myOptions = new LinkedList();
        this.myCommand = null;
        while ((value = this.nextOption()) != null) {
            this.myOptions.add(value);
        }
    }

    private SVNOptionValue nextOption() throws SVNException {
        String optionName;
        AbstractSVNOption option;
        String argument;
        if (this.myArgumentPosition == 0) {
            while (this.myArgumentIndex < this.myInputArguments.length && !this.myInputArguments[this.myArgumentIndex].startsWith("-")) {
                argument = this.myInputArguments[this.myArgumentIndex];
                if (this.myNeedsCommand && this.myCommand == null) {
                    this.myCommand = argument;
                } else {
                    this.myArguments.add(argument);
                }
                ++this.myArgumentIndex;
            }
            if (this.myArgumentIndex >= this.myInputArguments.length) {
                return null;
            }
            argument = this.myInputArguments[this.myArgumentIndex];
            if (argument.startsWith("--")) {
                int valueIndex = argument.indexOf(61);
                String optionName2 = valueIndex > 0 ? argument.substring(0, valueIndex) : argument;
                AbstractSVNOption option2 = (AbstractSVNOption)ourOptions.get(optionName2);
                if (option2 == null) {
                    SVNErrorMessage err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_ARG_PARSING_ERROR, (String)"invalid option: {0}", (Object)optionName2);
                    SVNErrorManager.error((SVNErrorMessage)err, (SVNLogType)SVNLogType.CLIENT);
                }
                String value = null;
                if (!option2.isUnary()) {
                    if (valueIndex > 0) {
                        value = argument.substring(valueIndex + 1);
                    } else {
                        ++this.myArgumentIndex;
                        String string = value = this.myArgumentIndex < this.myInputArguments.length ? this.myInputArguments[this.myArgumentIndex] : null;
                    }
                    if (value == null) {
                        SVNErrorMessage err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_ARG_PARSING_ERROR, (String)"missing argument: {0}", (Object)optionName2);
                        SVNErrorManager.error((SVNErrorMessage)err, (SVNLogType)SVNLogType.CLIENT);
                    }
                }
                ++this.myArgumentIndex;
                return new SVNOptionValue(option2, optionName2, value);
            }
            this.myArgumentPosition = 1;
        }
        if ((option = (AbstractSVNOption)ourOptions.get(optionName = "-".equals(argument = this.myInputArguments[this.myArgumentIndex]) ? "" : "-" + argument.charAt(this.myArgumentPosition++))) == null) {
            SVNErrorMessage err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_ARG_PARSING_ERROR, (String)"invalid option: {0}", (Object)optionName);
            SVNErrorManager.error((SVNErrorMessage)err, (SVNLogType)SVNLogType.CLIENT);
        }
        String value = null;
        if (!option.isUnary()) {
            if (this.myArgumentPosition < argument.length()) {
                value = argument.substring(this.myArgumentPosition);
                if (value.startsWith("=")) {
                    value = value.substring(1);
                }
            } else {
                ++this.myArgumentIndex;
                value = this.myArgumentIndex < this.myInputArguments.length ? this.myInputArguments[this.myArgumentIndex] : null;
            }
            this.myArgumentPosition = 0;
            ++this.myArgumentIndex;
            if (value == null) {
                SVNErrorMessage err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_ARG_PARSING_ERROR, (String)"missing argument: {0}", (Object)optionName);
                SVNErrorManager.error((SVNErrorMessage)err, (SVNLogType)SVNLogType.CLIENT);
            }
        }
        if (this.myArgumentPosition >= argument.length()) {
            this.myArgumentPosition = 0;
            ++this.myArgumentIndex;
        }
        return new SVNOptionValue(option, optionName, value);
    }

    public Iterator optionValues() {
        return this.myOptions.iterator();
    }

    public String getCommandName() {
        return this.myCommand;
    }

    public Collection getArguments() {
        return this.myArguments;
    }
}

