/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.javahl17;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.subversion.javahl.ClientException;
import org.apache.subversion.javahl.ISVNConfig;
import org.apache.subversion.javahl.types.Tristate;
import org.tmatesoft.svn.core.internal.wc.SVNCompositeConfigFile;

public class JavaHLConfigCategory
implements ISVNConfig.Category {
    private static final Set<String> TRUE_VALUES = new HashSet<String>(Arrays.asList("yes", "on", "true"));
    private static final Set<String> FALSE_VALUES = new HashSet<String>(Arrays.asList("no", "off", "false"));
    private static final String ASK_VALUE = "ask";
    private final SVNCompositeConfigFile configFile;

    public JavaHLConfigCategory(SVNCompositeConfigFile configFile) {
        this.configFile = configFile;
    }

    @Override
    public String get(String section, String option, String defaultValue) {
        String propertyValue = this.configFile.getPropertyValue(section, option);
        return propertyValue == null ? defaultValue : propertyValue;
    }

    @Override
    public boolean get(String section, String option, boolean defaultValue) throws ClientException {
        String propertyValue = this.configFile.getPropertyValue(section, option);
        return propertyValue == null ? defaultValue : TRUE_VALUES.contains(propertyValue.toLowerCase());
    }

    @Override
    public long get(String section, String option, long defaultValue) throws ClientException {
        String propertyValue = this.configFile.getPropertyValue(section, option);
        try {
            return propertyValue == null ? defaultValue : Long.parseLong(propertyValue);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    @Override
    public Tristate get(String section, String option, String unknown, Tristate defaultValue) throws ClientException {
        String propertyValue = this.configFile.getPropertyValue(section, option);
        if (propertyValue == null) {
            return defaultValue;
        }
        if (TRUE_VALUES.contains(propertyValue.toLowerCase())) {
            return Tristate.True;
        }
        if (FALSE_VALUES.contains(propertyValue.toLowerCase())) {
            return Tristate.False;
        }
        return Tristate.Unknown;
    }

    @Override
    public String getYesNoAsk(String section, String option, String defaultValue) throws ClientException {
        String propertyValue = this.configFile.getPropertyValue(section, option);
        return propertyValue == null ? defaultValue : propertyValue;
    }

    @Override
    public void set(String section, String option, String value) {
        this.configFile.setPropertyValue(section, option, value, true);
    }

    @Override
    public void set(String section, String option, boolean value) {
        this.configFile.setPropertyValue(section, option, String.valueOf(value), true);
    }

    @Override
    public void set(String section, String option, long value) {
        this.configFile.setPropertyValue(section, option, String.valueOf(value), true);
    }

    @Override
    public Iterable<String> sections() {
        return this.configFile.getGroupNames();
    }

    @Override
    public void enumerate(String section, ISVNConfig.Enumerator handler) {
        Map properties = this.configFile.getProperties(section);
        Set entrySet = properties.entrySet();
        for (Map.Entry entry : entrySet) {
            String option = (String)entry.getKey();
            String value = (String)entry.getValue();
            handler.option(option, value);
        }
    }
}

