/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.svn.ssh.apache;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.sshd.common.channel.exception.SshChannelClosedException;

public class StreamPiper
implements Closeable {
    private int copied;
    private Thread thread = new Thread(() -> {
        Logger log = Logger.getLogger(StreamPiper.class.getName() + "#" + name);
        try {
            byte[] buf = new byte[2048];
            for (int emptyRead = 0; !this.thread.isInterrupted() || emptyRead < 10; ++emptyRead) {
                int length;
                while (in.available() > 0 && (length = in.read(buf)) > 0) {
                    out.write(buf, 0, length);
                    this.copied += length;
                    emptyRead = 0;
                }
                out.flush();
                Thread.sleep(10L);
            }
        }
        catch (SshChannelClosedException e) {
            log.fine("Channel closed " + e);
        }
        catch (IOException e) {
            log.log(Level.FINE, "Failed while streaming", e);
        }
        catch (InterruptedException e) {
            log.log(Level.FINE, "Got interrupted", e);
        }
    });

    public StreamPiper(String name, InputStream in, OutputStream out) {
        this.thread.setName("Piping " + name);
        this.thread.start();
    }

    @Override
    public void close() {
        if (this.thread != null) {
            if (this.thread.isAlive()) {
                this.thread.interrupt();
                try {
                    this.thread.join();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException("Got interrupted", e);
                }
            }
            this.thread = null;
        }
    }

    public int getCopied() {
        return this.copied;
    }
}

