/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.svn.ssh.apache;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.sshd.client.channel.ChannelExec;
import org.apache.sshd.client.channel.ClientChannelEvent;
import org.apache.sshd.client.future.OpenFuture;
import org.apache.sshd.client.session.ClientSession;
import org.tmatesoft.svn.core.internal.io.svn.ssh.SshSession;
import org.tmatesoft.svn.core.internal.io.svn.ssh.apache.SshConnection;

public class ApacheSshSession
implements SshSession {
    private static final Logger log = Logger.getLogger(ApacheSshSession.class.getName());
    private SshConnection connection;
    private boolean closeConnection;
    private ChannelExec channel;
    private PipedInputStream out;
    private PipedInputStream err;
    private PipedOutputStream in;
    private static int execCount;

    public ApacheSshSession(SshConnection connection) {
        this.connection = connection;
        this.closeConnection = false;
    }

    public static int getExecCount() {
        return execCount;
    }

    @Override
    public void close() {
        if (this.channel != null) {
            try {
                this.channel.close(false).await();
                this.channel.waitFor(Collections.singleton(ClientChannelEvent.CLOSED), 10000L);
            }
            catch (Exception e) {
                log.log(Level.WARNING, "Failed to close channel", e);
            }
        }
        this.connection.sessionClosed(this);
        if (this.closeConnection) {
            this.connection.close();
        }
    }

    @Override
    public InputStream getOut() {
        if (this.in == null) {
            throw new IllegalStateException("execCommand must be called first");
        }
        return this.out;
    }

    @Override
    public InputStream getErr() {
        if (this.in == null) {
            throw new IllegalStateException("execCommand must be called first");
        }
        return this.err;
    }

    @Override
    public OutputStream getIn() {
        if (this.in == null) {
            throw new IllegalStateException("execCommand must be called first");
        }
        return this.in;
    }

    @Override
    public void waitForCondition(int code, long timeout) {
    }

    @Override
    public void execCommand(String command) throws IOException {
        ++execCount;
        try {
            this.tryExecCommand(command);
        }
        catch (Exception e) {
            this.close();
            this.connection.close();
            this.connection = this.connection.reOpen();
            this.closeConnection = true;
            this.tryExecCommand(command);
        }
    }

    private void tryExecCommand(String command) throws IOException {
        this.channel = this.connection.getSession().createExecChannel(command);
        this.out = new PipedInputStream();
        this.channel.setOut(new PipedOutputStream(this.out));
        this.err = new PipedInputStream();
        this.channel.setErr(new PipedOutputStream(this.err));
        this.in = new PipedOutputStream();
        this.channel.setIn(new PipedInputStream(this.in));
        OpenFuture future = this.channel.open();
        future.await();
        if (!future.isOpened()) {
            Throwable exception = future.getException();
            if (exception != null) {
                throw new IOException(exception);
            }
            throw new IOException("Cannot open channel");
        }
        log.finest(() -> "Opened connection with " + command);
    }

    @Override
    public void ping() throws IOException {
        ClientSession session = this.connection.getSession();
        if (!session.isOpen()) {
            throw new IOException("Session is not open");
        }
        if (session.isClosing()) {
            throw new IOException("Session is closing");
        }
    }
}

