/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core;

import org.eclipse.osgi.framework.log.FrameworkLog;
import org.eclipse.osgi.framework.log.FrameworkLogEntry;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;
import org.tmatesoft.svn.core.SVNKitLog;
import org.tmatesoft.svn.core.internal.io.svn.SVNSSHConnector;
import org.tmatesoft.svn.util.SVNDebugLog;

public class SVNKitActivator
implements BundleActivator {
    private ServiceTracker myDebugTracker = null;
    private ServiceTracker myFLogTracker = null;
    private String myPluginID;

    public void start(BundleContext context) throws Exception {
        this.myPluginID = context.getBundle().getSymbolicName();
        this.myDebugTracker = new ServiceTracker(context, DebugOptions.class.getName(), null);
        this.myDebugTracker.open();
        this.myFLogTracker = new ServiceTracker(context, FrameworkLog.class.getName(), null);
        this.myFLogTracker.open();
        SVNKitLog debugLog = new SVNKitLog(this);
        SVNDebugLog.setDefaultLog(debugLog);
    }

    public boolean getDebugOption(String option) {
        if (this.myDebugTracker == null) {
            return false;
        }
        DebugOptions options = (DebugOptions)this.myDebugTracker.getService();
        if (options != null) {
            option = this.myPluginID + option;
            String value = options.getOption(option);
            return "true".equalsIgnoreCase(value);
        }
        return false;
    }

    public FrameworkLogEntry createFrameworkLogEntry(int level, String message, Throwable th) {
        return new FrameworkLogEntry(this.myPluginID, level, 0, message, 0, th, null);
    }

    public FrameworkLog getFrameworkLog() {
        if (this.myFLogTracker == null) {
            return null;
        }
        FrameworkLog log = (FrameworkLog)this.myFLogTracker.getService();
        if (log != null) {
            return log;
        }
        return null;
    }

    public void stop(BundleContext context) throws Exception {
        SVNSSHConnector.shutdown();
        try {
            if (this.myDebugTracker != null) {
                this.myDebugTracker.close();
            }
        }
        finally {
            this.myDebugTracker = null;
        }
        try {
            if (this.myFLogTracker != null) {
                this.myFLogTracker.close();
            }
        }
        finally {
            this.myFLogTracker = null;
        }
    }
}

