/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.map;

import java.util.Set;
import org.tmatesoft.sqljet.core.SqlJetEncoding;
import org.tmatesoft.sqljet.core.SqlJetErrorCode;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.internal.ISqlJetBtree;
import org.tmatesoft.sqljet.core.internal.ISqlJetMemoryPointer;
import org.tmatesoft.sqljet.core.internal.SqlJetUnpackedRecordFlags;
import org.tmatesoft.sqljet.core.internal.SqlJetUtility;
import org.tmatesoft.sqljet.core.internal.table.ISqlJetBtreeRecord;
import org.tmatesoft.sqljet.core.internal.table.SqlJetBtreeTable;
import org.tmatesoft.sqljet.core.internal.vdbe.SqlJetBtreeRecord;
import org.tmatesoft.sqljet.core.internal.vdbe.SqlJetUnpackedRecord;
import org.tmatesoft.sqljet.core.map.ISqlJetMapIndexCursor;
import org.tmatesoft.sqljet.core.map.SqlJetMapDb;
import org.tmatesoft.sqljet.core.schema.ISqlJetIndexDef;

public class SqlJetMapIndexCursor
extends SqlJetBtreeTable
implements ISqlJetMapIndexCursor {
    private final SqlJetMapDb mapDb;

    public SqlJetMapIndexCursor(SqlJetMapDb mapDb, ISqlJetBtree btree, ISqlJetIndexDef indexDef, boolean writable) throws SqlJetException {
        super(btree, indexDef.getPage(), writable, true);
        if (!mapDb.isInTransaction()) {
            throw new SqlJetException(SqlJetErrorCode.MISUSE, "Cursor requires active transaction");
        }
        this.mapDb = mapDb;
    }

    public Object[] getKey() throws SqlJetException {
        Object[] values = this.getValues();
        if (values != null && values.length > 1) {
            int i = values.length - 1;
            Object[] key = new Object[i];
            System.arraycopy(values, 0, key, 0, i);
            return key;
        }
        return null;
    }

    public Long getValue() throws SqlJetException {
        Object value;
        Object[] values = this.getValues();
        if (values != null && values.length > 1 && (value = values[values.length - 1]) != null && value instanceof Long) {
            return (Long)value;
        }
        return null;
    }

    public boolean goToKey(Object[] key) throws SqlJetException {
        if (key != null && key.length > 0) {
            SqlJetEncoding encoding = this.mapDb.getOptions().getEncoding();
            ISqlJetBtreeRecord rec = SqlJetBtreeRecord.getRecord(encoding, key);
            ISqlJetMemoryPointer pKey = rec.getRawRecord();
            rec.release();
            int moveTo = this.moveTo(pKey, pKey.remaining(), false);
            if (moveTo < 0 && !this.next()) {
                return false;
            }
            if (moveTo != 0) {
                ISqlJetBtreeRecord record = this.getRecord();
                if (null == record) {
                    return false;
                }
                if (this.keyCompare(key.length, pKey, record.getRawRecord()) != 0) {
                    return false;
                }
            }
            return true;
        }
        throw new SqlJetException("Key must be not null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int keyCompare(int keyLength, ISqlJetMemoryPointer key, ISqlJetMemoryPointer record) throws SqlJetException {
        this.getKeyInfo().setNField(keyLength);
        SqlJetUnpackedRecord unpacked = this.getKeyInfo().recordUnpack(key.remaining(), key);
        Set<SqlJetUnpackedRecordFlags> flags = unpacked.getFlags();
        flags.add(SqlJetUnpackedRecordFlags.IGNORE_ROWID);
        flags.add(SqlJetUnpackedRecordFlags.PREFIX_MATCH);
        try {
            int n = unpacked.recordCompare(record.remaining(), record);
            return n;
        }
        finally {
            unpacked.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Object[] key, Long value) throws SqlJetException {
        if (this.write) {
            if (value != null) {
                this.lock();
                try {
                    SqlJetEncoding encoding = this.mapDb.getOptions().getEncoding();
                    ISqlJetBtreeRecord rec = SqlJetBtreeRecord.getRecord(encoding, SqlJetUtility.addArrays(key, new Object[]{value}));
                    ISqlJetMemoryPointer zKey = rec.getRawRecord();
                    this.getCursor().insert(zKey, zKey.remaining(), SqlJetUtility.allocatePtr(0), 0, 0, true);
                    this.clearRecordCache();
                    rec.release();
                }
                finally {
                    this.unlock();
                }
            } else if (this.goToKey(key)) {
                this.delete();
            }
        } else {
            throw new SqlJetException("Read-only");
        }
    }
}

