/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli.svnlook;

import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import org.tmatesoft.svn.cli.SVNCommandUtil;
import org.tmatesoft.svn.cli.svnlook.SVNLookCommand;
import org.tmatesoft.svn.cli.svnlook.SVNLookCommandEnvironment;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLock;
import org.tmatesoft.svn.core.internal.util.SVNDate;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.admin.SVNLookClient;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNLookLockCommand
extends SVNLookCommand {
    protected SVNLookLockCommand() {
        super("lock", null);
    }

    @Override
    protected Collection createSupportedOptions() {
        return new LinkedList();
    }

    @Override
    public void run() throws SVNException {
        SVNLookClient client;
        SVNLock lock;
        SVNLookCommandEnvironment environment = this.getSVNLookEnvironment();
        String path = environment.getFirstArgument();
        if (environment.getFirstArgument() == null) {
            SVNErrorMessage err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_INSUFFICIENT_ARGS, (String)"Missing path argument");
            SVNErrorManager.error((SVNErrorMessage)err, (SVNLogType)SVNLogType.CLIENT);
        }
        if ((lock = (client = environment.getClientManager().getLookClient()).doGetLock(environment.getRepositoryFile(), path)) != null) {
            String comment;
            ISVNOptions options = this.getEnvironment().getClientManager().getOptions();
            String creationDate = SVNDate.formatHumanDate((Date)lock.getCreationDate(), (ISVNOptions)options);
            String expirationDate = lock.getExpirationDate() != null ? SVNDate.formatHumanDate((Date)lock.getExpirationDate(), (ISVNOptions)options) : "";
            int commentLinesCount = lock.getComment() != null ? SVNCommandUtil.getLinesCount(lock.getComment()) : 0;
            this.getSVNLookEnvironment().getOut().println("UUID Token: " + lock.getID());
            this.getSVNLookEnvironment().getOut().println("Owner: " + lock.getOwner());
            this.getSVNLookEnvironment().getOut().println("Created: " + creationDate);
            this.getSVNLookEnvironment().getOut().println("Expires: " + expirationDate);
            String countMessage = "Comment (" + commentLinesCount + " ";
            String string = comment = lock.getComment() != null ? lock.getComment() : "";
            if (commentLinesCount != 1) {
                this.getSVNLookEnvironment().getOut().println(countMessage + " lines):");
                this.getSVNLookEnvironment().getOut().println(comment);
            } else {
                this.getSVNLookEnvironment().getOut().println(countMessage + "line):");
                this.getSVNLookEnvironment().getOut().println(comment);
            }
        }
    }
}

