/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli.svndumpfilter;

import java.io.File;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import org.tmatesoft.svn.cli.AbstractSVNCommand;
import org.tmatesoft.svn.cli.AbstractSVNCommandEnvironment;
import org.tmatesoft.svn.cli.AbstractSVNOption;
import org.tmatesoft.svn.cli.SVNCommandLine;
import org.tmatesoft.svn.cli.SVNOptionValue;
import org.tmatesoft.svn.cli.svndumpfilter.SVNDumpFilterCommand;
import org.tmatesoft.svn.cli.svndumpfilter.SVNDumpFilterHelpCommand;
import org.tmatesoft.svn.cli.svndumpfilter.SVNDumpFilterOption;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNOptions;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNDumpFilterCommandEnvironment
extends AbstractSVNCommandEnvironment {
    private boolean myIsVersion;
    private boolean myIsQuiet;
    private boolean myIsHelp;
    private boolean myIsDropEmptyRevisions;
    private boolean myIsRenumberRevisions;
    private boolean myIsPreserveRevisionProperties;
    private boolean myIsSkipMissingMergeSources;
    private List myPrefixes;
    private String myTargetsFile;

    public boolean isVersion() {
        return this.myIsVersion;
    }

    public boolean isQuiet() {
        return this.myIsQuiet;
    }

    public boolean isHelp() {
        return this.myIsHelp;
    }

    public boolean isDropEmptyRevisions() {
        return this.myIsDropEmptyRevisions;
    }

    public boolean isRenumberRevisions() {
        return this.myIsRenumberRevisions;
    }

    public boolean isPreserveRevisionProperties() {
        return this.myIsPreserveRevisionProperties;
    }

    public boolean isSkipMissingMergeSources() {
        return this.myIsSkipMissingMergeSources;
    }

    public List getPrefixes() {
        return this.myPrefixes;
    }

    public SVNDumpFilterCommandEnvironment(String programName, PrintStream out, PrintStream err, InputStream in) {
        super(programName, out, err, in);
    }

    @Override
    protected ISVNAuthenticationManager createClientAuthenticationManager() {
        return null;
    }

    @Override
    protected DefaultSVNOptions createClientOptions() throws SVNException {
        return null;
    }

    @Override
    protected void initOptions(SVNCommandLine commandLine) throws SVNException {
        super.initOptions(commandLine);
        if (this.getCommand().getClass() == SVNDumpFilterHelpCommand.class) {
            return;
        }
        List arguments = this.getArguments();
        this.myPrefixes = new LinkedList();
        if (arguments != null) {
            for (String prefix : arguments) {
                prefix = prefix.replace(File.separatorChar, '/');
                if (!(prefix = SVNPathUtil.canonicalizePath((String)prefix)).startsWith("/")) {
                    prefix = "/" + prefix;
                }
                this.myPrefixes.add(prefix);
            }
        }
        if (this.myTargetsFile != null) {
            File targetsFile = new File(this.myTargetsFile);
            String contents = new String(this.readFromFile(targetsFile));
            StringTokenizer tokens = new StringTokenizer(contents, "\n\r");
            while (tokens.hasMoreTokens()) {
                String prefix = tokens.nextToken();
                this.myPrefixes.add(prefix);
            }
        }
        if (this.myPrefixes.isEmpty()) {
            SVNErrorMessage err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_INSUFFICIENT_ARGS, (String)"Error: no prefixes supplied.");
            SVNErrorManager.error((SVNErrorMessage)err, (SVNLogType)SVNLogType.CLIENT);
        }
    }

    @Override
    protected void initOption(SVNOptionValue optionValue) throws SVNException {
        AbstractSVNOption option = optionValue.getOption();
        if (option == SVNDumpFilterOption.DROP_EMPTY_REVISIONS) {
            this.myIsDropEmptyRevisions = true;
        } else if (option == SVNDumpFilterOption.RENUMBER_REVISIONS) {
            this.myIsRenumberRevisions = true;
        } else if (option == SVNDumpFilterOption.PRESERVE_REVISION_PROPERTIES) {
            this.myIsPreserveRevisionProperties = true;
        } else if (option == SVNDumpFilterOption.SKIP_MISSING_MERGE_SOURCES) {
            this.myIsSkipMissingMergeSources = true;
        } else if (option == SVNDumpFilterOption.VERSION) {
            this.myIsVersion = true;
        } else if (option == SVNDumpFilterOption.QUIET) {
            this.myIsQuiet = true;
        } else if (option == SVNDumpFilterOption.TARGETS) {
            this.myTargetsFile = optionValue.getValue();
        } else if (option == SVNDumpFilterOption.HELP || option == SVNDumpFilterOption.QUESTION) {
            this.myIsHelp = true;
        }
    }

    @Override
    protected String refineCommandName(String commandName, SVNCommandLine commandLine) throws SVNException {
        Iterator options = commandLine.optionValues();
        while (options.hasNext()) {
            SVNOptionValue optionValue = (SVNOptionValue)options.next();
            AbstractSVNOption option = optionValue.getOption();
            if (option == SVNDumpFilterOption.HELP || option == SVNDumpFilterOption.QUESTION) {
                this.myIsHelp = true;
                continue;
            }
            if (option != SVNDumpFilterOption.VERSION) continue;
            this.myIsVersion = true;
        }
        if (this.myIsHelp) {
            List<String> newArguments = commandName != null ? Collections.singletonList(commandName) : Collections.EMPTY_LIST;
            this.setArguments(newArguments);
            return "help";
        }
        if (commandName == null) {
            if (this.isVersion()) {
                SVNDumpFilterCommand versionCommand = new SVNDumpFilterCommand("--version", null, 0){

                    @Override
                    protected Collection createSupportedOptions() {
                        LinkedList<SVNDumpFilterOption> options = new LinkedList<SVNDumpFilterOption>();
                        options.add(SVNDumpFilterOption.VERSION);
                        return options;
                    }

                    @Override
                    public void run() throws SVNException {
                        AbstractSVNCommand helpCommand = AbstractSVNCommand.getCommand("help");
                        helpCommand.init(SVNDumpFilterCommandEnvironment.this);
                        helpCommand.run();
                    }
                };
                AbstractSVNCommand.registerCommand(versionCommand);
                return "--version";
            }
            SVNErrorMessage err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_INSUFFICIENT_ARGS, (String)"Subcommand argument required");
            SVNErrorManager.error((SVNErrorMessage)err, (SVNLogType)SVNLogType.CLIENT);
        }
        return commandName;
    }

    @Override
    protected String getCommandLineClientName() {
        return "svndumpfilter";
    }
}

