/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc2.ng;

import java.io.File;
import java.io.OutputStream;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc2.ng.ISvnDiffGenerator;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnDiffCallback;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNewDiffGenerator;
import org.tmatesoft.svn.core.wc.DefaultSVNDiffGenerator;
import org.tmatesoft.svn.core.wc.ISVNDiffGenerator;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class SvnOldDiffGenerator
implements ISvnDiffGenerator {
    private final ISVNDiffGenerator generator;
    private SvnTarget repositoryRoot;

    public SvnOldDiffGenerator(ISVNDiffGenerator generator) {
        this.generator = generator;
    }

    public ISVNDiffGenerator getDelegate() {
        return this.generator;
    }

    public void setOriginalTargets(SvnTarget originalTarget1, SvnTarget originalTarget2) {
    }

    public void setAnchors(SvnTarget originalTarget1, SvnTarget originalTarget2) {
        this.generator.init(this.getDisplayPath(originalTarget2), this.getDisplayPath(originalTarget2));
    }

    public void setBaseTarget(SvnTarget baseTarget) {
        if (baseTarget.isFile()) {
            this.generator.setBasePath(baseTarget.getFile());
        }
    }

    public void setRepositoryRoot(SvnTarget repositoryRoot) {
        this.repositoryRoot = repositoryRoot;
    }

    public void setEncoding(String encoding) {
        this.generator.setEncoding(encoding);
    }

    public String getEncoding() {
        return this.generator.getEncoding();
    }

    public String getGlobalEncoding() {
        if (this.generator instanceof DefaultSVNDiffGenerator) {
            return ((DefaultSVNDiffGenerator)this.generator).getGlobalEncoding();
        }
        return null;
    }

    public void setEOL(byte[] eol) {
        this.generator.setEOL(eol);
    }

    public byte[] getEOL() {
        return this.generator.getEOL();
    }

    public void setForceEmpty(boolean forceEmpty) {
    }

    public void setForcedBinaryDiff(boolean forced) {
        this.generator.setForcedBinaryDiff(forced);
    }

    public void setUseGitFormat(boolean useGitFormat) {
        if (this.generator instanceof SvnNewDiffGenerator) {
            ((SvnNewDiffGenerator)this.generator).getDelegate().setUseGitFormat(useGitFormat);
        }
    }

    public void displayDeletedDirectory(SvnTarget displayPath, String revision1, String revision2, OutputStream outputStream) throws SVNException {
        this.generator.displayDeletedDirectory(this.getDisplayPath(displayPath), revision1, revision2);
    }

    public void displayAddedDirectory(SvnTarget displayPath, String revision1, String revision2, OutputStream outputStream) throws SVNException {
        this.generator.displayAddedDirectory(this.getDisplayPath(displayPath), revision1, revision2);
    }

    public void displayPropsChanged(SvnTarget displayPath, String revision1, String revision2, boolean dirWasAdded, SVNProperties originalProps, SVNProperties propChanges, OutputStream outputStream) throws SVNException {
        this.generator.displayPropDiff(this.getDisplayPath(displayPath), originalProps, propChanges, outputStream);
    }

    public void displayContentChanged(SvnTarget displayPath, File leftFile, File rightFile, String revision1, String revision2, String mimeType1, String mimeType2, SvnDiffCallback.OperationKind operation, File copyFromPath, OutputStream outputStream) throws SVNException {
        if (operation == SvnDiffCallback.OperationKind.Deleted && !this.generator.isDiffDeleted() || operation == SvnDiffCallback.OperationKind.Added && !this.generator.isDiffAdded() || operation == SvnDiffCallback.OperationKind.Copied && !this.generator.isDiffCopied()) {
            return;
        }
        this.generator.displayFileDiff(this.getDisplayPath(displayPath), leftFile, rightFile, revision1, revision2, mimeType1, mimeType2, outputStream);
    }

    private String getDisplayPath(SvnTarget path) {
        if (path.isFile()) {
            String absolutePath = path.getFile().getAbsolutePath().replace(File.separatorChar, '/');
            String currentPath = new File("").getAbsolutePath();
            String relativePath = SVNPathUtil.getRelativePath(currentPath, absolutePath);
            if (relativePath != null) {
                return relativePath;
            }
            return absolutePath;
        }
        return path.getPathOrUrlString();
    }

    public boolean isForcedBinaryDiff() {
        return this.generator.isForcedBinaryDiff();
    }
}

