/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.dav.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;

public class XMLReader
extends Reader {
    public static final char COLON_REPLACEMENT = '\u3007';
    private Reader mySource;
    private boolean myIsEscaping;
    private int myColonCount;
    private boolean myIsClosed;

    public XMLReader(InputStream is) throws UnsupportedEncodingException {
        this.mySource = new InputStreamReader(is, "UTF-8");
    }

    public int read(char[] b, int off, int len) throws IOException {
        int read = this.mySource.read(b, off, len);
        for (int i = 0; i < read; ++i) {
            char ch = b[off + i];
            if (ch < ' ' && ch != '\r' && ch != '\n' && ch != '\t') {
                b[off + i] = 32;
                continue;
            }
            if (ch == '\uffff' || ch == '\ufffe') {
                b[off + i] = 32;
                continue;
            }
            if (this.myIsEscaping) {
                if (ch == ':') {
                    ++this.myColonCount;
                    if (this.myColonCount <= 1) continue;
                    b[off + i] = 12295;
                    continue;
                }
                if (!Character.isWhitespace(ch) && ch != '>') continue;
                this.myIsEscaping = false;
                continue;
            }
            if (this.myIsEscaping || ch != '<') continue;
            this.myIsEscaping = true;
            this.myColonCount = 0;
        }
        this.myIsClosed = read < 0;
        return read;
    }

    public boolean isClosed() {
        return this.myIsClosed;
    }

    public void close() throws IOException {
    }
}

