/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.dav.handlers;

import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.io.dav.DAVElement;
import org.tmatesoft.svn.core.internal.io.dav.handlers.BasicDAVHandler;
import org.tmatesoft.svn.core.internal.util.SVNXMLUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.io.ISVNLocationSegmentHandler;
import org.tmatesoft.svn.core.io.SVNLocationSegment;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.util.SVNLogType;
import org.xml.sax.Attributes;

public class DAVLocationSegmentsHandler
extends BasicDAVHandler {
    private static final DAVElement LOCATION_SEGMENTS_REPORT = DAVElement.getElement("svn:", "get-location-segments-report");
    private static final DAVElement LOCATION_SEGMENT = DAVElement.getElement("svn:", "location-segment");
    private ISVNLocationSegmentHandler myLocationSegmentHandler;
    private long myCount;

    public static StringBuffer generateGetLocationSegmentsRequest(StringBuffer xmlBuffer, String path, long pegRevision, long startRevision, long endRevision) {
        xmlBuffer = xmlBuffer == null ? new StringBuffer() : xmlBuffer;
        SVNXMLUtil.addXMLHeader(xmlBuffer);
        SVNXMLUtil.openNamespaceDeclarationTag("S", "get-location-segments", SVN_DAV_NAMESPACES_LIST, SVNXMLUtil.PREFIX_MAP, xmlBuffer);
        SVNXMLUtil.openCDataTag("S", "path", path, xmlBuffer);
        if (SVNRevision.isValidRevisionNumber(pegRevision)) {
            SVNXMLUtil.openCDataTag("S", "peg-revision", String.valueOf(pegRevision), xmlBuffer);
        }
        if (SVNRevision.isValidRevisionNumber(startRevision)) {
            SVNXMLUtil.openCDataTag("S", "start-revision", String.valueOf(startRevision), xmlBuffer);
        }
        if (SVNRevision.isValidRevisionNumber(endRevision)) {
            SVNXMLUtil.openCDataTag("S", "end-revision", String.valueOf(endRevision), xmlBuffer);
        }
        SVNXMLUtil.addXMLFooter("S", "get-location-segments", xmlBuffer);
        return xmlBuffer;
    }

    public DAVLocationSegmentsHandler(ISVNLocationSegmentHandler handler) {
        this.myLocationSegmentHandler = handler;
        this.init();
    }

    public long getTotalRevisions() {
        return this.myCount;
    }

    protected void startElement(DAVElement parent, DAVElement element, Attributes attrs) throws SVNException {
        if (parent == LOCATION_SEGMENTS_REPORT && element == LOCATION_SEGMENT) {
            String revStr;
            long rangeStart = -1L;
            long rangeEnd = -1L;
            String path = attrs.getValue("path");
            if (path != null && !path.startsWith("/")) {
                path = "/" + path;
            }
            if ((revStr = attrs.getValue("range-start")) != null) {
                try {
                    rangeStart = Long.parseLong(revStr);
                }
                catch (NumberFormatException nfe) {
                    SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.RA_DAV_MALFORMED_DATA, nfe), SVNLogType.NETWORK);
                }
            }
            if ((revStr = attrs.getValue("range-end")) != null) {
                try {
                    rangeEnd = Long.parseLong(revStr);
                }
                catch (NumberFormatException nfe) {
                    SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.RA_DAV_MALFORMED_DATA, nfe), SVNLogType.NETWORK);
                }
            }
            if (SVNRevision.isValidRevisionNumber(rangeStart) && SVNRevision.isValidRevisionNumber(rangeEnd)) {
                if (this.myLocationSegmentHandler != null) {
                    this.myLocationSegmentHandler.handleLocationSegment(new SVNLocationSegment(rangeStart, rangeEnd, path));
                    this.myCount += rangeEnd - rangeStart + 1L;
                }
            } else {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_DAV_MALFORMED_DATA, "Expected valid revision range");
                SVNErrorManager.error(err, SVNLogType.NETWORK);
            }
        }
    }

    protected void endElement(DAVElement parent, DAVElement element, StringBuffer cdata) throws SVNException {
    }
}

