/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli.svnadmin;

import java.io.File;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.tmatesoft.svn.cli.AbstractSVNCommand;
import org.tmatesoft.svn.cli.AbstractSVNCommandEnvironment;
import org.tmatesoft.svn.cli.AbstractSVNOption;
import org.tmatesoft.svn.cli.SVNCommandLine;
import org.tmatesoft.svn.cli.SVNOptionValue;
import org.tmatesoft.svn.cli.svnadmin.SVNAdminCommand;
import org.tmatesoft.svn.cli.svnadmin.SVNAdminOption;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNOptions;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNWCUtil;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNAdminCommandEnvironment
extends AbstractSVNCommandEnvironment {
    private boolean myIsQuiet;
    private boolean myIsHelp;
    private boolean myIsVersion;
    private String myParentDir;
    private boolean myIsIncremental;
    private boolean myIsDeltas;
    private boolean myIsIgnoreUUID;
    private boolean myIsForceUUID;
    private boolean myIsPre14Compatible;
    private boolean myIsPre15Compatible;
    private boolean myIsPre16Compatible;
    private boolean myIsPre17Compatible;
    private boolean myIsWith17Compatible;
    private boolean myIsUsePreCommitHook;
    private boolean myIsUsePostCommitHook;
    private boolean myIsUsePostRevPropChangeHook;
    private boolean myIsUsePreRevPropChangeHook;
    private boolean myIsBypassHooks;
    private boolean myIsCleanLogs;
    private String myConfigDir;
    private boolean myIsWait;
    private SVNRevision myStartRevision = SVNRevision.UNDEFINED;
    private SVNRevision myEndRevision = SVNRevision.UNDEFINED;

    protected SVNAdminCommandEnvironment(String programName, PrintStream out, PrintStream err, InputStream in) {
        super(programName, out, err, in);
    }

    protected ISVNAuthenticationManager createClientAuthenticationManager() {
        File configDir = this.myConfigDir != null ? new File(this.myConfigDir).getAbsoluteFile() : null;
        return SVNWCUtil.createDefaultAuthenticationManager(configDir);
    }

    protected DefaultSVNOptions createClientOptions() {
        File configDir = this.myConfigDir != null ? new File(this.myConfigDir).getAbsoluteFile() : null;
        return SVNWCUtil.createDefaultOptions(configDir, (boolean)true);
    }

    protected void initOption(SVNOptionValue optionValue) throws SVNException {
        AbstractSVNOption option = optionValue.getOption();
        if (option == SVNAdminOption.REVISION) {
            String revStr;
            SVNRevision[] revisions;
            if (this.myStartRevision != SVNRevision.UNDEFINED) {
                SVNErrorMessage err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_ARG_PARSING_ERROR, (String)"Multiple revision argument encountered; can't specify -r and c, or try '-r N:M' instead of '-r N -r M'");
                SVNErrorManager.error((SVNErrorMessage)err, (SVNLogType)SVNLogType.CLIENT);
            }
            if ((revisions = this.parseRevision(revStr = optionValue.getValue())) == null) {
                SVNErrorMessage err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_ARG_PARSING_ERROR, (String)"Syntax error in revision argument ''{0}''", (Object)revStr);
                SVNErrorManager.error((SVNErrorMessage)err, (SVNLogType)SVNLogType.CLIENT);
            }
            this.myStartRevision = revisions[0];
            this.myEndRevision = revisions[1];
        } else if (option == SVNAdminOption.QUIET) {
            this.myIsQuiet = true;
        } else if (option == SVNAdminOption.HELP || option == SVNAdminOption.QUESTION) {
            this.myIsHelp = true;
        } else if (option == SVNAdminOption.VERSION) {
            this.myIsVersion = true;
        } else if (option == SVNAdminOption.INCREMENTAL) {
            this.myIsIncremental = true;
        } else if (option == SVNAdminOption.DELTAS) {
            this.myIsDeltas = true;
        } else if (option == SVNAdminOption.IGNORE_UUID) {
            this.myIsIgnoreUUID = true;
        } else if (option == SVNAdminOption.FORCE_UUID) {
            this.myIsForceUUID = true;
        } else if (option == SVNAdminOption.PRE_14_COMPATIBLE) {
            this.myIsPre14Compatible = true;
        } else if (option == SVNAdminOption.PRE_15_COMPATIBLE) {
            this.myIsPre15Compatible = true;
        } else if (option == SVNAdminOption.PRE_16_COMPATIBLE) {
            this.myIsPre16Compatible = true;
        } else if (option == SVNAdminOption.PRE_17_COMPATIBLE) {
            this.myIsPre17Compatible = true;
        } else if (option == SVNAdminOption.WITH_17_COMPATIBLE) {
            this.myIsWith17Compatible = true;
        } else if (option == SVNAdminOption.PARENT_DIR) {
            this.myParentDir = optionValue.getValue();
            this.myParentDir = this.myParentDir.replace(File.separatorChar, '/');
            this.myParentDir = SVNPathUtil.canonicalizePath((String)this.myParentDir);
        } else if (option == SVNAdminOption.USE_PRE_COMMIT_HOOK) {
            this.myIsUsePreCommitHook = true;
        } else if (option == SVNAdminOption.USE_POST_COMMIT_HOOK) {
            this.myIsUsePostCommitHook = true;
        } else if (option == SVNAdminOption.USE_POST_REVPROP_CHANGE_HOOK) {
            this.myIsUsePostRevPropChangeHook = true;
        } else if (option == SVNAdminOption.USE_PRE_REVPROP_CHANGE_HOOK) {
            this.myIsUsePreRevPropChangeHook = true;
        } else if (option == SVNAdminOption.BYPASS_HOOKS) {
            this.myIsBypassHooks = true;
        } else if (option == SVNAdminOption.CLEAN_LOGS) {
            this.myIsCleanLogs = true;
        } else if (option == SVNAdminOption.CONFIG_DIR) {
            this.myConfigDir = optionValue.getValue();
        } else if (option == SVNAdminOption.WAIT) {
            this.myIsWait = true;
        }
    }

    protected String refineCommandName(String commandName, SVNCommandLine commandLine) throws SVNException {
        Iterator options = commandLine.optionValues();
        while (options.hasNext()) {
            SVNOptionValue optionValue = (SVNOptionValue)options.next();
            AbstractSVNOption option = optionValue.getOption();
            if (option == SVNAdminOption.HELP || option == SVNAdminOption.QUESTION) {
                this.myIsHelp = true;
                continue;
            }
            if (option != SVNAdminOption.VERSION) continue;
            this.myIsVersion = true;
        }
        if (this.myIsHelp) {
            List<String> newArguments = commandName != null ? Collections.singletonList(commandName) : Collections.EMPTY_LIST;
            this.setArguments(newArguments);
            return "help";
        }
        if (commandName == null) {
            if (this.isVersion()) {
                SVNAdminCommand versionCommand = new SVNAdminCommand("--version", null){

                    protected Collection createSupportedOptions() {
                        LinkedList<SVNAdminOption> options = new LinkedList<SVNAdminOption>();
                        options.add(SVNAdminOption.VERSION);
                        options.add(SVNAdminOption.QUIET);
                        return options;
                    }

                    public void run() throws SVNException {
                        AbstractSVNCommand helpCommand = AbstractSVNCommand.getCommand("help");
                        helpCommand.init(SVNAdminCommandEnvironment.this);
                        helpCommand.run();
                    }
                };
                AbstractSVNCommand.registerCommand(versionCommand);
                return "--version";
            }
            SVNErrorMessage err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_INSUFFICIENT_ARGS, (String)"Subcommand argument required");
            SVNErrorManager.error((SVNErrorMessage)err, (SVNLogType)SVNLogType.CLIENT);
        }
        return commandName;
    }

    protected String getCommandLineClientName() {
        return "svnadmin";
    }

    public boolean isQuiet() {
        return this.myIsQuiet;
    }

    public boolean isHelp() {
        return this.myIsHelp;
    }

    public boolean isVersion() {
        return this.myIsVersion;
    }

    public String getParentDir() {
        return this.myParentDir;
    }

    public boolean isIncremental() {
        return this.myIsIncremental;
    }

    public boolean isDeltas() {
        return this.myIsDeltas;
    }

    public boolean isIgnoreUUID() {
        return this.myIsIgnoreUUID;
    }

    public boolean isForceUUID() {
        return this.myIsForceUUID;
    }

    public boolean isPre14Compatible() {
        return this.myIsPre14Compatible;
    }

    public boolean isPre15Compatible() {
        return this.myIsPre15Compatible;
    }

    public boolean isPre16Compatible() {
        return this.myIsPre16Compatible;
    }

    public boolean isPre17Compatible() {
        return this.myIsPre17Compatible;
    }

    public boolean isWith17Compatible() {
        return this.myIsWith17Compatible;
    }

    public boolean isUsePreCommitHook() {
        return this.myIsUsePreCommitHook;
    }

    public boolean isUsePostCommitHook() {
        return this.myIsUsePostCommitHook;
    }

    public boolean isUsePostRevPropChangeHook() {
        return this.myIsUsePostRevPropChangeHook;
    }

    public boolean isUsePreRevPropChangeHook() {
        return this.myIsUsePreRevPropChangeHook;
    }

    public boolean isBypassHooks() {
        return this.myIsBypassHooks;
    }

    public boolean isCleanLogs() {
        return this.myIsCleanLogs;
    }

    public boolean isWait() {
        return this.myIsWait;
    }

    public SVNRevision getStartRevision() {
        return this.myStartRevision;
    }

    public SVNRevision getEndRevision() {
        return this.myEndRevision;
    }
}

