/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli.svn;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.tmatesoft.svn.cli.svn.SVNCommand;
import org.tmatesoft.svn.cli.svn.SVNNotifyPrinter;
import org.tmatesoft.svn.cli.svn.SVNOption;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNPath;
import org.tmatesoft.svn.core.wc.ISVNCommitHandler;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNCopyClient;
import org.tmatesoft.svn.core.wc.SVNCopySource;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNMoveCommand
extends SVNCommand {
    public SVNMoveCommand() {
        super("move", new String[]{"mv", "rename", "ren"});
    }

    public boolean isCommitter() {
        return true;
    }

    protected Collection createSupportedOptions() {
        Collection<SVNOption> options = new LinkedList<SVNOption>();
        options.add(SVNOption.REVISION);
        options.add(SVNOption.QUIET);
        options.add(SVNOption.FORCE);
        options.add(SVNOption.PARENTS);
        options = SVNOption.addLogMessageOptions(options);
        return options;
    }

    public void run() throws SVNException {
        SVNPath dst;
        List<String> targets = this.getSVNEnvironment().combineTargets(null, true);
        if (targets.size() < 2) {
            SVNErrorManager.error((SVNErrorMessage)SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_INSUFFICIENT_ARGS), (SVNLogType)SVNLogType.CLIENT);
        }
        if (this.getSVNEnvironment().getStartRevision() != SVNRevision.UNDEFINED && this.getSVNEnvironment().getStartRevision() != SVNRevision.HEAD) {
            SVNErrorManager.error((SVNErrorMessage)SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.UNSUPPORTED_FEATURE, (String)"Cannot specify revision (except HEAD) with move operation"), (SVNLogType)SVNLogType.CLIENT);
        }
        if (!((dst = new SVNPath(targets.remove(targets.size() - 1))).isURL() || this.getSVNEnvironment().getMessage() == null && this.getSVNEnvironment().getFileData() == null && this.getSVNEnvironment().getRevisionProperties() == null)) {
            SVNErrorManager.error((SVNErrorMessage)SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_UNNECESSARY_LOG_MESSAGE, (String)"Local, non-commit operations do not take a log message or revision properties"), (SVNLogType)SVNLogType.CLIENT);
        }
        SVNCopyClient client = this.getSVNEnvironment().getClientManager().getCopyClient();
        if (!this.getSVNEnvironment().isQuiet()) {
            client.setEventHandler((ISVNEventHandler)new SVNNotifyPrinter(this.getSVNEnvironment()));
        }
        client.setCommitHandler((ISVNCommitHandler)this.getSVNEnvironment());
        ArrayList<SVNCopySource> sources = new ArrayList<SVNCopySource>();
        for (String targetName : targets) {
            SVNPath source = new SVNPath(targetName);
            if (source.isURL()) {
                sources.add(new SVNCopySource(SVNRevision.HEAD, SVNRevision.UNDEFINED, source.getURL()));
                continue;
            }
            sources.add(new SVNCopySource(this.getSVNEnvironment().getStartRevision(), SVNRevision.UNDEFINED, source.getFile()));
        }
        SVNCopySource[] copySources = sources.toArray(new SVNCopySource[sources.size()]);
        try {
            if (dst.isURL()) {
                SVNCommitInfo info = client.doCopy(copySources, dst.getURL(), true, this.getSVNEnvironment().isParents(), false, this.getSVNEnvironment().getMessage(), this.getSVNEnvironment().getRevisionProperties());
                if (!this.getSVNEnvironment().isQuiet()) {
                    this.getSVNEnvironment().printCommitInfo(info);
                }
            } else {
                client.doCopy(copySources, dst.getFile(), true, this.getSVNEnvironment().isParents(), false);
            }
        }
        catch (SVNException e) {
            SVNErrorMessage err = e.getErrorMessage();
            SVNErrorCode code = err.getErrorCode();
            if (code == SVNErrorCode.UNVERSIONED_RESOURCE || code == SVNErrorCode.CLIENT_MODIFIED) {
                err = err.wrap("Use --force to override this restriction");
            }
            SVNErrorManager.error((SVNErrorMessage)err, (Throwable)e, (SVNLogType)SVNLogType.CLIENT);
        }
    }
}

