/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli.svn;

import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.tmatesoft.svn.cli.svn.SVNOption;
import org.tmatesoft.svn.cli.svn.SVNXMLCommand;
import org.tmatesoft.svn.core.ISVNDirEntryHandler;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNDirEntry;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLock;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.internal.util.SVNDate;
import org.tmatesoft.svn.core.internal.util.SVNFormatUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNPath;
import org.tmatesoft.svn.core.wc.SVNLogClient;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNListCommand
extends SVNXMLCommand
implements ISVNDirEntryHandler {
    public SVNListCommand() {
        super("list", new String[]{"ls"});
    }

    protected Collection createSupportedOptions() {
        LinkedList<SVNOption> options = new LinkedList<SVNOption>();
        options.add(SVNOption.REVISION);
        options.add(SVNOption.VERBOSE);
        options.add(SVNOption.RECURSIVE);
        options.add(SVNOption.DEPTH);
        options.add(SVNOption.INCREMENTAL);
        options.add(SVNOption.XML);
        return options;
    }

    public void run() throws SVNException {
        SVNDepth depth;
        List<String> targets = this.getSVNEnvironment().combineTargets(null, true);
        if (targets.isEmpty()) {
            targets.add("");
        }
        if (this.getSVNEnvironment().isXML()) {
            if (this.getSVNEnvironment().isVerbose()) {
                SVNErrorManager.error((SVNErrorMessage)SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_ARG_PARSING_ERROR, (String)"'verbose' option invalid in XML mode"), (SVNLogType)SVNLogType.CLIENT);
            }
            if (!this.getSVNEnvironment().isIncremental()) {
                this.printXMLHeader("lists");
            }
        } else if (this.getSVNEnvironment().isIncremental()) {
            SVNErrorManager.error((SVNErrorMessage)SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_ARG_PARSING_ERROR, (String)"'incremental' option only valid in XML mode"), (SVNLogType)SVNLogType.CLIENT);
        }
        if ((depth = this.getSVNEnvironment().getDepth()) == SVNDepth.UNKNOWN) {
            depth = SVNDepth.IMMEDIATES;
        }
        int fields = this.getSVNEnvironment().isXML() || this.getSVNEnvironment().isVerbose() ? -1 : 17;
        boolean fetchLocks = this.getSVNEnvironment().isXML() || this.getSVNEnvironment().isVerbose();
        SVNLogClient client = this.getSVNEnvironment().getClientManager().getLogClient();
        boolean seenNonExistentPaths = false;
        for (int i = 0; i < targets.size(); ++i) {
            StringBuffer buffer;
            String targetName = targets.get(i);
            SVNPath target = new SVNPath(targetName, true);
            if (this.getSVNEnvironment().isXML()) {
                buffer = this.openXMLTag("list", 1, "path", "".equals(target.getTarget()) ? "." : target.getTarget(), new StringBuffer());
                this.getSVNEnvironment().getOut().print(buffer.toString());
            }
            try {
                if (!target.isURL()) {
                    client.doList(target.getFile(), target.getPegRevision(), this.getSVNEnvironment().getStartRevision(), fetchLocks, depth, fields, (ISVNDirEntryHandler)this);
                } else {
                    client.doList(target.getURL(), target.getPegRevision(), this.getSVNEnvironment().getStartRevision(), fetchLocks, depth, fields, (ISVNDirEntryHandler)this);
                }
            }
            catch (SVNException e) {
                this.getSVNEnvironment().handleWarning(e.getErrorMessage(), new SVNErrorCode[]{SVNErrorCode.WC_PATH_NOT_FOUND, SVNErrorCode.FS_NOT_FOUND}, this.getSVNEnvironment().isQuiet());
                seenNonExistentPaths = true;
            }
            if (!this.getSVNEnvironment().isXML()) continue;
            buffer = this.closeXMLTag("list", new StringBuffer());
            this.getSVNEnvironment().getOut().print(buffer.toString());
        }
        if (this.getSVNEnvironment().isXML() && !this.getSVNEnvironment().isIncremental()) {
            this.printXMLFooter("lists");
        }
        if (seenNonExistentPaths) {
            SVNErrorMessage err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.ILLEGAL_TARGET, (String)"Could not list all targets because some targets don't exist");
            SVNErrorManager.error((SVNErrorMessage)err, (SVNLogType)SVNLogType.CLIENT);
        }
    }

    public void handleDirEntry(SVNDirEntry dirEntry) throws SVNException {
        if (this.getSVNEnvironment().isXML()) {
            this.printDirEntryXML(dirEntry);
        } else {
            this.printDirEntry(dirEntry);
        }
    }

    protected void printDirEntry(SVNDirEntry dirEntry) {
        String path = dirEntry.getRelativePath();
        if ("".equals(path)) {
            if (this.getSVNEnvironment().isVerbose() && dirEntry.getKind() == SVNNodeKind.DIR) {
                path = ".";
            } else if (dirEntry.getKind() == SVNNodeKind.DIR) {
                return;
            }
        }
        StringBuffer buffer = new StringBuffer();
        if (this.getSVNEnvironment().isVerbose()) {
            String author;
            buffer.append(SVNFormatUtil.formatString((String)(dirEntry.getRevision() + ""), (int)7, (boolean)false));
            buffer.append(' ');
            String string = author = dirEntry.getAuthor() == null ? " ? " : dirEntry.getAuthor();
            if (author.length() > 8) {
                author = author.substring(0, 8);
            }
            buffer.append(SVNFormatUtil.formatString((String)author, (int)8, (boolean)true));
            buffer.append(' ');
            buffer.append(dirEntry.getLock() != null ? (char)'O' : ' ');
            buffer.append(' ');
            buffer.append(SVNFormatUtil.formatString((String)(dirEntry.getKind() == SVNNodeKind.DIR ? "" : dirEntry.getSize() + ""), (int)10, (boolean)false));
            buffer.append(' ');
            Date d = dirEntry.getDate();
            String timeStr = "";
            if (d != null) {
                timeStr = System.currentTimeMillis() - d.getTime() < 735614464L ? SVNDate.formatConsoleShortDate((Date)d) : SVNDate.formatConsoleLongDate((Date)d);
            }
            buffer.append(SVNFormatUtil.formatString((String)timeStr, (int)12, (boolean)false));
            buffer.append(' ');
        }
        buffer.append(path);
        if (dirEntry.getKind() == SVNNodeKind.DIR) {
            buffer.append('/');
        }
        buffer.append('\n');
        this.getSVNEnvironment().getOut().print(buffer.toString());
    }

    protected void printDirEntryXML(SVNDirEntry dirEntry) {
        String path = dirEntry.getRelativePath();
        if ("".equals(path)) {
            if (this.getSVNEnvironment().isVerbose() && dirEntry.getKind() == SVNNodeKind.DIR) {
                path = ".";
            } else if (dirEntry.getKind() == SVNNodeKind.DIR) {
                return;
            }
        }
        StringBuffer buffer = new StringBuffer();
        buffer = this.openXMLTag("entry", 1, "kind", dirEntry.getKind().toString(), buffer);
        buffer = this.openCDataTag("name", path, buffer);
        if (dirEntry.getKind() == SVNNodeKind.FILE) {
            buffer = this.openCDataTag("size", Long.toString(dirEntry.getSize()), buffer);
        }
        buffer = this.openXMLTag("commit", 1, "revision", Long.toString(dirEntry.getRevision()), buffer);
        buffer = this.openCDataTag("author", dirEntry.getAuthor(), buffer);
        if (dirEntry.getDate() != null) {
            buffer = this.openCDataTag("date", ((SVNDate)dirEntry.getDate()).format(), buffer);
        }
        buffer = this.closeXMLTag("commit", buffer);
        SVNLock lock = dirEntry.getLock();
        if (lock != null) {
            buffer = this.openXMLTag("lock", 1, null, buffer);
            buffer = this.openCDataTag("token", lock.getID(), buffer);
            buffer = this.openCDataTag("owner", lock.getOwner(), buffer);
            buffer = this.openCDataTag("comment", lock.getComment(), buffer);
            buffer = this.openCDataTag("created", ((SVNDate)lock.getCreationDate()).format(), buffer);
            if (lock.getExpirationDate() != null && lock.getExpirationDate().getTime() > 0L) {
                buffer = this.openCDataTag("expires", ((SVNDate)lock.getExpirationDate()).format(), buffer);
            }
            buffer = this.closeXMLTag("lock", buffer);
        }
        buffer = this.closeXMLTag("entry", buffer);
        this.getSVNEnvironment().getOut().print(buffer.toString());
    }
}

