/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli.svn;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.tmatesoft.svn.cli.SVNCommandUtil;
import org.tmatesoft.svn.cli.svn.SVNOption;
import org.tmatesoft.svn.cli.svn.SVNXMLCommand;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLock;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.internal.util.SVNDate;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNConflictVersion;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNPath;
import org.tmatesoft.svn.core.internal.wc.SVNTreeConflictUtil;
import org.tmatesoft.svn.core.wc.ISVNInfoHandler;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.SVNConflictAction;
import org.tmatesoft.svn.core.wc.SVNConflictReason;
import org.tmatesoft.svn.core.wc.SVNInfo;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNTreeConflictDescription;
import org.tmatesoft.svn.core.wc.SVNWCClient;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNInfoCommand
extends SVNXMLCommand
implements ISVNInfoHandler {
    public SVNInfoCommand() {
        super("info", null);
    }

    protected Collection createSupportedOptions() {
        LinkedList<SVNOption> options = new LinkedList<SVNOption>();
        options.add(SVNOption.REVISION);
        options.add(SVNOption.RECURSIVE);
        options.add(SVNOption.DEPTH);
        options.add(SVNOption.TARGETS);
        options.add(SVNOption.INCREMENTAL);
        options.add(SVNOption.XML);
        options.add(SVNOption.CHANGELIST);
        return options;
    }

    public void run() throws SVNException {
        SVNDepth depth;
        List<Object> targets = new ArrayList();
        if (this.getSVNEnvironment().getTargets() != null) {
            targets.addAll(this.getSVNEnvironment().getTargets());
        }
        if ((targets = this.getSVNEnvironment().combineTargets(targets, true)).isEmpty()) {
            targets.add("");
        }
        if (this.getSVNEnvironment().isXML()) {
            if (!this.getSVNEnvironment().isIncremental()) {
                this.printXMLHeader("info");
            }
        } else if (this.getSVNEnvironment().isIncremental()) {
            SVNErrorManager.error((SVNErrorMessage)SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_ARG_PARSING_ERROR, (String)"'incremental' option only valid in XML mode"), (SVNLogType)SVNLogType.CLIENT);
        }
        if ((depth = this.getSVNEnvironment().getDepth()) == SVNDepth.UNKNOWN) {
            depth = SVNDepth.EMPTY;
        }
        SVNWCClient client = this.getSVNEnvironment().getClientManager().getWCClient();
        boolean seenNonExistingTargets = false;
        for (int i = 0; i < targets.size(); ++i) {
            String targetName = (String)targets.get(i);
            SVNPath target = new SVNPath(targetName, true);
            SVNRevision pegRevision = target.getPegRevision();
            if (target.isURL() && pegRevision == SVNRevision.UNDEFINED) {
                pegRevision = SVNRevision.HEAD;
            }
            try {
                if (target.isFile()) {
                    client.doInfo(target.getFile(), pegRevision, this.getSVNEnvironment().getStartRevision(), depth, this.getSVNEnvironment().getChangelistsCollection(), (ISVNInfoHandler)this);
                    continue;
                }
                client.doInfo(target.getURL(), pegRevision, this.getSVNEnvironment().getStartRevision(), depth, (ISVNInfoHandler)this);
                continue;
            }
            catch (SVNException e) {
                SVNErrorMessage err = e.getErrorMessage();
                if (err.getErrorCode() == SVNErrorCode.UNVERSIONED_RESOURCE) {
                    this.getSVNEnvironment().getErr().print(SVNCommandUtil.getLocalPath(target.getTarget()) + ": (Not a versioned resource)\n\n");
                    continue;
                }
                this.getSVNEnvironment().handleWarning(err, new SVNErrorCode[]{SVNErrorCode.RA_ILLEGAL_URL, SVNErrorCode.WC_PATH_NOT_FOUND}, this.getSVNEnvironment().isQuiet());
                this.getSVNEnvironment().getErr().println();
                seenNonExistingTargets = true;
            }
        }
        if (this.getSVNEnvironment().isXML() && !this.getSVNEnvironment().isIncremental()) {
            this.printXMLFooter("info");
        }
        if (seenNonExistingTargets) {
            SVNErrorManager.error((SVNErrorMessage)SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.ILLEGAL_TARGET, (String)"Could not display info for all targets because some targets don't exist"), (SVNLogType)SVNLogType.CLIENT);
        }
    }

    public void handleInfo(SVNInfo info) throws SVNException {
        if (!this.getSVNEnvironment().isXML()) {
            this.printInfo(info);
        } else {
            this.printInfoXML(info);
        }
    }

    protected void printInfo(SVNInfo info) {
        StringBuffer buffer = new StringBuffer();
        String path = null;
        if (info.getFile() != null) {
            path = this.getSVNEnvironment().getRelativePath(info.getFile());
            path = SVNCommandUtil.getLocalPath(path);
        } else {
            path = info.getPath();
            if ("".equals(path) && info.getURL() != null) {
                path = SVNPathUtil.tail((String)info.getURL().getPath());
            }
        }
        buffer.append("Path: " + path + "\n");
        if (info.getKind() != SVNNodeKind.DIR) {
            buffer.append("Name: " + SVNPathUtil.tail((String)path.replace(File.separatorChar, '/')) + "\n");
        }
        if (info.getWorkingCopyRoot() != null) {
            buffer.append("Working Copy Root Path: " + SVNPathUtil.validateFilePath((String)info.getWorkingCopyRoot().getAbsolutePath()) + "\n");
        }
        buffer.append("URL: " + info.getURL() + "\n");
        if (info.getRepositoryRootURL() != null) {
            buffer.append("Repository Root: " + info.getRepositoryRootURL() + "\n");
        }
        if (info.getRepositoryUUID() != null) {
            buffer.append("Repository UUID: " + info.getRepositoryUUID() + "\n");
        }
        if (info.getRevision() != null && info.getRevision().isValid()) {
            buffer.append("Revision: " + info.getRevision() + "\n");
        }
        String kind = info.getKind() == SVNNodeKind.DIR ? "directory" : (info.getKind() != null ? info.getKind().toString() : "none");
        buffer.append("Node Kind: " + kind + "\n");
        if (!info.isRemote()) {
            if (info.getSchedule() == null) {
                buffer.append("Schedule: normal\n");
            } else {
                buffer.append("Schedule: " + info.getSchedule() + "\n");
            }
            if (info.getDepth() != null && info.getDepth() != SVNDepth.UNKNOWN && info.getDepth() != SVNDepth.INFINITY) {
                buffer.append("Depth: " + info.getDepth() + "\n");
            }
            if (info.getCopyFromURL() != null) {
                buffer.append("Copied From URL: " + info.getCopyFromURL() + "\n");
            }
            if (info.getCopyFromRevision() != null && info.getCopyFromRevision().getNumber() >= 0L) {
                buffer.append("Copied From Rev: " + info.getCopyFromRevision() + "\n");
            }
        }
        if (info.getAuthor() != null) {
            buffer.append("Last Changed Author: " + info.getAuthor() + "\n");
        }
        if (info.getCommittedRevision() != null && info.getCommittedRevision().getNumber() >= 0L) {
            buffer.append("Last Changed Rev: " + info.getCommittedRevision() + "\n");
        }
        if (info.getCommittedDate() != null) {
            buffer.append("Last Changed Date: " + SVNDate.formatHumanDate((Date)info.getCommittedDate(), (ISVNOptions)this.getSVNEnvironment().getClientManager().getOptions()) + "\n");
        }
        if (!info.isRemote()) {
            String cpath;
            if (info.getTextTime() != null) {
                buffer.append("Text Last Updated: " + SVNDate.formatHumanDate((Date)info.getTextTime(), (ISVNOptions)this.getSVNEnvironment().getClientManager().getOptions()) + "\n");
            }
            if (info.getPropTime() != null) {
                buffer.append("Properties Last Updated: " + SVNDate.formatHumanDate((Date)info.getPropTime(), (ISVNOptions)this.getSVNEnvironment().getClientManager().getOptions()) + "\n");
            }
            if (info.getChecksum() != null) {
                buffer.append("Checksum: " + info.getChecksum() + "\n");
            }
            if (info.getConflictOldFile() != null) {
                cpath = this.getSVNEnvironment().getRelativePath(info.getConflictOldFile());
                cpath = SVNCommandUtil.getLocalPath(cpath);
                buffer.append("Conflict Previous Base File: " + cpath + "\n");
            }
            if (info.getConflictWrkFile() != null) {
                cpath = this.getSVNEnvironment().getRelativePath(info.getConflictWrkFile());
                cpath = SVNCommandUtil.getLocalPath(cpath);
                buffer.append("Conflict Previous Working File: " + cpath + "\n");
            }
            if (info.getConflictNewFile() != null) {
                cpath = this.getSVNEnvironment().getRelativePath(info.getConflictNewFile());
                cpath = SVNCommandUtil.getLocalPath(cpath);
                buffer.append("Conflict Current Base File: " + cpath + "\n");
            }
            if (info.getPropConflictFile() != null) {
                cpath = this.getSVNEnvironment().getRelativePath(info.getPropConflictFile());
                cpath = SVNCommandUtil.getLocalPath(cpath);
                buffer.append("Conflict Properties File: " + cpath + "\n");
            }
        }
        if (info.getLock() != null) {
            SVNLock lock = info.getLock();
            if (lock.getID() != null) {
                buffer.append("Lock Token: " + lock.getID() + "\n");
            }
            if (lock.getOwner() != null) {
                buffer.append("Lock Owner: " + lock.getOwner() + "\n");
            }
            if (lock.getCreationDate() != null && lock.getCreationDate().getTime() != 0L) {
                buffer.append("Lock Created: " + SVNDate.formatHumanDate((Date)lock.getCreationDate(), (ISVNOptions)this.getSVNEnvironment().getClientManager().getOptions()) + "\n");
            }
            if (lock.getExpirationDate() != null && lock.getExpirationDate().getTime() != 0L) {
                buffer.append("Lock Expires: " + SVNDate.formatHumanDate((Date)lock.getExpirationDate(), (ISVNOptions)this.getSVNEnvironment().getClientManager().getOptions()) + "\n");
            }
            if (lock.getComment() != null) {
                buffer.append("Lock Comment ");
                int lineCount = SVNCommandUtil.getLinesCount(lock.getComment());
                buffer.append(lineCount > 1 ? "(" + lineCount + " lines)" : "(1 line)");
                buffer.append(":\n");
                buffer.append(lock.getComment());
                buffer.append("\n");
            }
        }
        if (info.getChangelistName() != null) {
            buffer.append("Changelist: " + info.getChangelistName() + "\n");
        }
        if (info.getTreeConflict() != null) {
            SVNTreeConflictDescription tc = info.getTreeConflict();
            String description = SVNTreeConflictUtil.getHumanReadableConflictDescription((SVNTreeConflictDescription)tc);
            buffer.append("Tree conflict: " + description + "\n");
            SVNConflictVersion left = tc.getSourceLeftVersion();
            buffer.append("  Source  left: " + SVNTreeConflictUtil.getHumanReadableConflictVersion((SVNConflictVersion)left) + "\n");
            SVNConflictVersion right = tc.getSourceRightVersion();
            buffer.append("  Source right: " + SVNTreeConflictUtil.getHumanReadableConflictVersion((SVNConflictVersion)right) + "\n");
        }
        buffer.append("\n");
        this.getSVNEnvironment().getOut().print(buffer.toString());
    }

    protected void printInfoXML(SVNInfo info) {
        StringBuffer buffer = new StringBuffer();
        String path = null;
        if (info.getFile() != null) {
            path = this.getSVNEnvironment().getRelativePath(info.getFile());
            path = SVNCommandUtil.getLocalPath(path);
        } else {
            path = info.getPath();
        }
        LinkedHashMap<String, String> attrs = new LinkedHashMap<String, String>();
        attrs.put("kind", info.getKind().toString());
        attrs.put("path", path);
        attrs.put("revision", info.getRevision() != SVNRevision.UNDEFINED ? info.getRevision().toString() : "Resource is not under version control.");
        buffer = this.openXMLTag("entry", 1, attrs, buffer);
        String url = info.getURL() != null ? info.getURL().toString() : null;
        buffer = this.openCDataTag("url", url, buffer);
        String rootURL = info.getRepositoryRootURL() != null ? info.getRepositoryRootURL().toString() : null;
        String uuid = info.getRepositoryUUID();
        if (rootURL != null || uuid != null) {
            buffer = this.openXMLTag("repository", 1, null, buffer);
            buffer = this.openCDataTag("root", rootURL, buffer);
            buffer = this.openCDataTag("uuid", uuid, buffer);
            buffer = this.closeXMLTag("repository", buffer);
        }
        if (info.getFile() != null) {
            String schedule;
            buffer = this.openXMLTag("wc-info", 1, null, buffer);
            if (info.getWorkingCopyRoot() != null) {
                buffer = this.openCDataTag("wcroot-abspath", SVNPathUtil.validateFilePath((String)info.getWorkingCopyRoot().getAbsolutePath()), buffer);
            }
            if ((schedule = info.getSchedule()) == null || "".equals(schedule)) {
                schedule = "normal";
            }
            buffer = this.openCDataTag("schedule", schedule, buffer);
            if (info.getDepth() != null) {
                SVNDepth depth = info.getDepth();
                if (depth == SVNDepth.UNKNOWN && info.getKind() == SVNNodeKind.FILE) {
                    depth = SVNDepth.INFINITY;
                }
                buffer = this.openCDataTag("depth", depth.getName(), buffer);
            }
            if (info.getCopyFromURL() != null) {
                buffer = this.openCDataTag("copy-from-url", info.getCopyFromURL().toString(), buffer);
            }
            if (info.getCopyFromRevision() != null && info.getCopyFromRevision().isValid()) {
                buffer = this.openCDataTag("copy-from-rev", info.getCopyFromRevision().toString(), buffer);
            }
            if (info.getTextTime() != null) {
                buffer = this.openCDataTag("text-updated", ((SVNDate)info.getTextTime()).format(), buffer);
            }
            if (info.getPropTime() != null) {
                buffer = this.openCDataTag("prop-updated", ((SVNDate)info.getPropTime()).format(), buffer);
            }
            buffer = this.openCDataTag("checksum", info.getChecksum(), buffer);
            buffer = this.openCDataTag("changelist", info.getChangelistName(), buffer);
            buffer = this.closeXMLTag("wc-info", buffer);
        }
        if (info.getAuthor() != null || info.getCommittedRevision().isValid() || info.getCommittedDate() != null) {
            this.openXMLTag("commit", 1, "revision", info.getCommittedRevision().toString(), buffer);
            buffer = this.openCDataTag("author", info.getAuthor(), buffer);
            if (info.getCommittedDate() != null) {
                buffer = this.openCDataTag("date", ((SVNDate)info.getCommittedDate()).format(), buffer);
            }
            buffer = this.closeXMLTag("commit", buffer);
        }
        if (info.getConflictNewFile() != null || info.getConflictOldFile() != null || info.getConflictWrkFile() != null || info.getPropConflictFile() != null) {
            buffer = this.openXMLTag("conflict", 1, null, buffer);
            if (info.getConflictOldFile() != null) {
                buffer = this.openCDataTag("prev-base-file", info.getConflictOldFile().getName(), buffer);
            }
            if (info.getConflictWrkFile() != null) {
                buffer = this.openCDataTag("prev-wc-file", info.getConflictWrkFile().getName(), buffer);
            }
            if (info.getConflictNewFile() != null) {
                buffer = this.openCDataTag("cur-base-file", info.getConflictNewFile().getName(), buffer);
            }
            if (info.getPropConflictFile() != null) {
                buffer = this.openCDataTag("prop-file", info.getPropConflictFile().getName(), buffer);
            }
            buffer = this.closeXMLTag("conflict", buffer);
        }
        if (info.getLock() != null) {
            SVNLock lock = info.getLock();
            buffer = this.openXMLTag("lock", 1, null, buffer);
            buffer = this.openCDataTag("token", lock.getID(), buffer);
            buffer = this.openCDataTag("owner", lock.getOwner(), buffer);
            buffer = this.openCDataTag("comment", lock.getComment(), buffer);
            if (lock.getCreationDate() != null) {
                buffer = this.openCDataTag("created", ((SVNDate)lock.getCreationDate()).format(), buffer);
            }
            if (lock.getExpirationDate() != null) {
                buffer = this.openCDataTag("expires", ((SVNDate)lock.getExpirationDate()).format(), buffer);
            }
            buffer = this.closeXMLTag("lock", buffer);
        }
        if (info.getTreeConflict() != null) {
            SVNConflictVersion right;
            SVNTreeConflictDescription tc = info.getTreeConflict();
            SVNHashMap attributes = new SVNHashMap();
            attributes.put("victim", tc.getPath().getName());
            attributes.put("kind", tc.getNodeKind().toString());
            attributes.put("operation", tc.getOperation().getName());
            if (tc.getConflictAction() == SVNConflictAction.EDIT) {
                attributes.put("action", "edit");
            } else if (tc.getConflictAction() == SVNConflictAction.ADD) {
                attributes.put("action", "add");
            } else if (tc.getConflictAction() == SVNConflictAction.DELETE) {
                attributes.put("action", "delete");
            }
            if (tc.getConflictReason() == SVNConflictReason.EDITED) {
                attributes.put("reason", "edit");
            } else if (tc.getConflictReason() == SVNConflictReason.OBSTRUCTED) {
                attributes.put("reason", "obstruction");
            } else if (tc.getConflictReason() == SVNConflictReason.DELETED) {
                attributes.put("reason", "delete");
            } else if (tc.getConflictReason() == SVNConflictReason.ADDED) {
                attributes.put("reason", "add");
            } else if (tc.getConflictReason() == SVNConflictReason.MISSING) {
                attributes.put("reason", "missing");
            } else if (tc.getConflictReason() == SVNConflictReason.UNVERSIONED) {
                attributes.put("reason", "unversioned");
            }
            buffer = this.openXMLTag("tree-conflict", 1, (Map)attributes, buffer);
            SVNConflictVersion left = tc.getSourceLeftVersion();
            if (left != null) {
                buffer = this.printConflictVersionXML(left, "source-left", buffer);
            }
            if ((right = tc.getSourceLeftVersion()) != null) {
                buffer = this.printConflictVersionXML(right, "source-right", buffer);
            }
            buffer = this.closeXMLTag("tree-conflict", buffer);
        }
        buffer = this.closeXMLTag("entry", buffer);
        this.getSVNEnvironment().getOut().print(buffer.toString());
    }

    private StringBuffer printConflictVersionXML(SVNConflictVersion version, String name, StringBuffer target) {
        SVNHashMap attributes = new SVNHashMap();
        attributes.put("side", name);
        if (version.getRepositoryRoot() != null) {
            attributes.put("repos-url", version.getRepositoryRoot().toString());
        }
        if (version.getPath() != null) {
            attributes.put("path-in-repos", version.getPath());
        }
        if (version.getPegRevision() >= 0L) {
            attributes.put("revision", Long.toString(version.getPegRevision()));
        }
        if (version.getKind() != SVNNodeKind.UNKNOWN) {
            attributes.put("kind", version.getKind().toString());
        }
        return this.openXMLTag("version", 4, (Map)attributes, target);
    }
}

